<?php

namespace App\Models\Parametros;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ParCCosto extends Model
{
    use HasFactory;
    protected $table = 'par_c_costos';
    protected $primaryKey = 'par_c_costo_id';
    protected $fillable = ['codigo', 'nombre', 'descripcion', 'nivel', 'par_c_c_padre_id', 'par_proyecto_id', 'empresa_id', 'estado'];

    public function parCCPadre()
    {
        return $this->belongsTo(ParCCPadre::class, 'par_c_c_padre_id');
    }

    public function proyecto()
    {
        return $this->belongsTo(ParProyecto::class, 'par_proyecto_id');
    }

    public function parEmpresa()
    {
        return $this->belongsTo(parEmpresa::class);
    }
}
