<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ParCCostosAcumulado extends Model
{
    use HasFactory;
       protected $table = 'par_c_costos_acumulado';
    protected $fillable = [
        'con_sii_compra_id', 'con_sub_cuenta_id', 'par_c_costo_id', 'par_proyecto_id',
        'empresa_id', 'anio', 'mes', 'total_debe', 'total_haber', 'estado'
    ];

    public function centroCosto()
    {
        return $this->belongsTo(ParCCosto::class, 'par_c_costo_id');
    }

    public function proyecto()
    {
        return $this->belongsTo(ParProyecto::class, 'par_proyecto_id');
    }

    public function subCuenta()
    {
        return $this->belongsTo(ConSubCuenta::class, 'con_sub_cuenta_id');
    }

    public function compra()
    {
        return $this->belongsTo(ConSiiCompra::class, 'con_sii_compra_id');
    }

    public function empresa()
    {
        return $this->belongsTo(Empresa::class);
    }

}
