<?php

namespace App\Models\Parametros;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Parametros\ParPais;
use App\Models\Parametros\ParRegion;
use App\Models\Parametros\ParComuna;
use App\Models\Parametros\ParCiudad;

class ParEmpresa extends Model
{
    use HasFactory;

    protected $table = 'par_empresas';

    public function parPais(){
        return $this->belongsTo(ParPais::class, 'par_pais_id');
    }

    public function parRegion(){
        return $this->belongsTo(ParRegion::class, 'par_region_id');
    }

    public function parComuna(){
        return $this->belongsTo(ParComuna::class, 'par_comuna_id');
    }

    public function parCiudad(){
        return $this->belongsTo(ParCiudad::class, 'par_ciudad_id');
    }

    public function FamiliaCentro(){
        return $this->belongsTo(\App\Models\FamiliaCentro::class);
    }

    public function Centro(){
        return $this->belongsTo(\App\Models\Centro::class);
    }

    public function UserEmpresa(){
        return $this->belongsTo(\App\Models\UserEmpresa::class);
    }

    public function UserSucursal(){
        return $this->belongsTo(\App\Models\UserSucursal::class);
    }

    public function certificados()
    {
        return $this->hasMany(\App\Models\Certificado::class);
    }

    // Relación al método de inventario
    public function metodoInventario()
    {
        return $this->hasOne(\App\Models\Pos\PosMetodoInventarios::class, 'par_empresa_id');
    }

}
