<?php

namespace App\Models\Parametros;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ParPeriodoEmpresa extends Model
{
    use HasFactory;

    protected $table = 'par_periodo_empresas';

    protected $fillable = [
        'par_empresa_id',
        'par_periodo_id',
    'par_periodo_id',
        'estado',
    ];

    // Relaciones opcionales
    public function parEmpresa()
    {
        return $this->belongsTo(ParEmpresa::class);
    }

   public function parPeriodo()
   {
       return $this->belongsTo(ParPeriodo::class, 'par_periodo_id');
   }
}
