<?php

namespace App\Models\Parametros;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * @property int $id
 * @property string $nombre
 * @property int $par_pais_id
 * @property int $estado
 *
 * @mixin \Illuminate\Database\Eloquent\Model
 * @method bool save(array $options = [])
 */
class ParRegion extends Model
{
    use HasFactory;
    public function Pais(){
        return $this->belongsTo(\App\Models\Parametros\ParPais::class, 'par_pais_id');
    }
    /** Tabla real con prefijo par_ */
    protected $table = 'par_regiones';

    public function Comunas(){
        return $this->hasMany(\App\Models\Parametros\ParComuna::class, 'par_region_id');
    }
    
}

// Legacy alias: keep class Region for backward compatibility
class Region extends ParRegion {}
