<?php

namespace App\Models\Parametros;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Parametros\ParEmpresa;
use App\Models\Certificado;

class ParRepresentante extends Model
{
    use HasFactory;

    protected $table = 'par_representantes';

    public function parEmpresa()
    {
        return $this->belongsTo(ParEmpresa::class);
    }

    public function certificados()
    {
        // relacionar por la clave adecuada: usar par_representante_id en certificados si se migró
        return $this->hasMany(Certificado::class, 'par_representante_id');
    }
}
