<?php

namespace App\Models\Parametros;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ParSucursal extends Model
{
    use HasFactory;

    /** tabla con prefijo par_ */
    protected $table = 'par_sucursales';

    public function parPais(){
        return $this->belongsTo(ParPais::class, 'par_pais_id');
    }

    public function parRegion(){
        return $this->belongsTo(ParRegion::class, 'par_region_id');
    }

    public function parComuna(){
        return $this->belongsTo(ParComuna::class, 'par_comuna_id');
    }

    public function parCiudad(){
        return $this->belongsTo(ParCiudad::class, 'par_ciudad_id');
    }

    public function parEmpresa(){
        return $this->belongsTo(ParEmpresa::class, 'par_empresa_id');
    }

    public function Trabajador(){
        return $this->belongsTo(\App\Models\Remuneraciones\RemFicha::class, 'rem_ficha_id');
    }

    public function UserSucursal(){
        return $this->hasMany(\App\Models\UserSucursal::class, 'par_sucursal_id');
    }
}
