<?php

namespace App\Models\Pos;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PosArriendoDetalle extends Model
{
    use HasFactory;
    /** Tabla real en la BD con prefijo pos_ */
    protected $table = 'pos_arriendo_detalles';
    protected $fillable = [
        'id',
        'maquinaria_id',
        'a_arriendo_id',
        'pos_a_recepcione_id',
        'pos_arriendo_id',
        'd_descuento',
        'valor',
        'f_entrada',
        'f_salida',
        'cantidad',
        'v_total',
        'estado',
    ];

    public function posMaquinaria(){
    return $this->belongsTo(\App\Models\Pos\PosMaquinaria::class);
    }
    public function marca()
    {
    return $this->belongsTo(\App\Models\Parametros\ParMarca::class, 'par_marca_id');
    }
    public function posArriendo(){
        return $this->belongsTo(PosArriendo::class, 'pos_arriendo_id');
    }


    public function posARecepcione(){
    return $this->belongsTo(\App\Models\Pos\PosARecepcione::class, 'pos_a_recepcione_id');
    }
}
