<?php
namespace App\Models\Pos;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PosArticuloImpuesto extends Model
{
    use HasFactory;
    protected $fillable = [
        'pos_articulo_id', 'con_impuesto_id', 'activo', 'optativo_en_venta'
    ];

    /**
     * Relación al artículo padre
     */
    public function posArticulo()
    {
        return $this->belongsTo(PosArticulo::class, 'pos_articulo_id');
    }

    /**
     * Relación al impuesto (pos_impuesto)
     */
    public function conImpuesto()
    {
        return $this->belongsTo(\App\Models\Contabilidad\ConImpuesto::class, 'con_impuesto_id');
    }
}
