<?php

namespace App\Models\Pos;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PosArticuloPackItem extends Model
{
    protected $table = 'pos_articulo_pack_items';

    protected $fillable = [
        'pack_id', 'item_articulo_id', 'cantidad', 'afecta_stock'
    ];

    public function pack()
    {
        return $this->belongsTo(PosArticulo::class, 'pack_id');
    }

    public function item()
    {
        return $this->belongsTo(PosArticulo::class, 'item_articulo_id');
    }
}
