<?php

namespace App\Models\Pos;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PosBodegaArticuloPackItem extends Model
{
    use HasFactory;

    protected $table = 'pos_bodega_articulos_pack_items';

    protected $fillable = [
        'pba_pack_id',   // id del pos_bodega_articulos que representa al PACK
        'pba_item_id',   // id del pos_bodega_articulos que representa al ÍTEM componente
        'cantidad',
        'afecta_stock',
    ];

    protected $casts = [
        'cantidad'     => 'float',
        'afecta_stock' => 'integer',
    ];

    // Relación al BA del PACK
    public function packBA()
    {
        return $this->belongsTo(PosBodegaArticulo::class, 'pba_pack_id');
    }

    // Relación al BA del ÍTEM
    public function itemBA()
    {
        return $this->belongsTo(PosBodegaArticulo::class, 'pba_item_id');
    }
}

