<?php

namespace App\Models\Pos;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PosCliente extends Model
{
    use HasFactory;
    protected $fillable = [
    'rut',
    'nombre',
    'razon_social',
    'par_empresa_id',
];
    public function parPais(){
        return $this->belongsTo(\App\Models\Parametros\ParPais::class);
    }
    public function parRegion(){
        return $this->belongsTo(\App\Models\Parametros\ParRegion::class);
    }
    public function parComuna(){
        return $this->belongsTo(\App\Models\Parametros\ParComuna::class);
    }
    public function parCiudad(){
        return $this->belongsTo(\App\Models\Parametros\ParCiudad::class);
    }
    public function parEmpresa(){
        return $this->belongsTo(\App\Models\Parametros\ParEmpresa::class);
    }
    public function parSucursal(){
        return $this->belongsTo(\App\Models\Parametros\ParSucursal::class);
    }
    public function User(){
        return $this->belongsTo(\App\Models\User::class);
    }
    public function posVenta(){
        return $this->belongsTo(\App\Models\Pos\PosVenta::class);
    }
}
