<?php

namespace App\Models\Pos;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PosCompra extends Model
{
    use HasFactory;

    protected $fillable = [
    'pos_orden_id',
    'fecha',
    'con_doc_tributario_id',
    'ndocumento',
    'pos_metodo_id',
    'par_empresa_id',
    'par_sucursal_id',
    'observacion',
    'pos_proveedor_id',
    'neto',
    'impuesto',
    'total',
    'usuario_id'
];

    public function Documento()
    {
        return $this->belongsTo(\App\Models\Contabilidad\ConDocTributario::class, 'con_doc_tributario_id');
    }

    public function Metodo()
    {
        return $this->belongsTo(\App\Models\Pos\PosMetodo::class, 'pos_metodo_id');
    }

    public function Proveedor()
    {
        return $this->belongsTo(\App\Models\Pos\PosProveedor::class, 'pos_proveedor_id');
    }
}
