<?php

namespace App\Models\Pos;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PosInventario extends Model
{
    use HasFactory;

    protected $fillable = [
    'movimiento',
    'fecha',
    'pos_bodega_articulo_id',
    'texto',
    'pos_bodega_id',
    'c_stock',
    'cantidad',
    'compra',
    'venta',
    'neto',
    'impuesto',
    'total',
    'consumido'
];

    public function Articulo(){
        return $this->belongsTo(PosArticulo::class);
    }
    public function Bodega(){
        return $this->belongsTo(PosBodega::class);
    }
    public function User(){
        return $this->belongsTo(\App\Models\User::class);
    }
    public function Impuesto(){
        return $this->belongsTo(\App\Models\Impuesto::class);
    }
}
