<?php

namespace App\Models\Pos;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PosMDMantencione extends Model
{
    use HasFactory;
    /** Tabla real en la BD con prefijo pos_ */
    protected $table = 'pos_m_d_mantenciones';

    protected $fillable = [
        'pos_mantencion_detalle_id',
        'pos_mantencione_id',
        'pos_maquinaria_id',
        'detalle',
        'cantidad',
        'valor',
        'total',
        'pos_m_d_mantencione_id',
    ];

    public function posMaquinaria(){
        return $this->belongsTo(PosMaquinaria::class);
    }
    public function parMarca()
    {
        return $this->belongsTo(\App\Models\Parametros\ParMarca::class, 'par_marca_id'); // Usa el campo correcto
    }
    public function posArriendo(){
        return $this->belongsTo(PosArriendo::class);
    }
    public function posMantencionDetalle()
    {
        return $this->belongsTo(PosMantencionDetalle::class, 'pos_mantencion_detalle_id');
    }
    public function posDespacho()
    {
        return $this->belongsTo(PosMDespacho::class, 'pos_m_despacho_id');
    }
}
