<?php

namespace App\Models\Pos;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PosMDespacho extends Model
{
    use HasFactory;
    /** Tabla real en la BD con prefijo pos_ */
    protected $table = 'pos_m_despachos';
    public function posCliente(){
        return $this->belongsTo(PosCliente::class);
    }
    public function posMaquinaria(){
        return $this->belongsTo(PosMaquinaria::class);
    }
    public function posMantencionDetalles()
    {
        return $this->hasMany(PosMantencionDetalle::class, 'pos_m_despacho_id');
    }
    public function posMantenciones()
    {
        return $this->hasMany(PosMantencionDetalle::class, 'pos_m_despacho_id');
    }
}
