<?php

namespace App\Models\Pos;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PosMantencionDetalle extends Model
{
    use HasFactory;
    /** Tabla real en la BD con prefijo pos_ */
    protected $table = 'pos_mantencion_detalles';
    public function posMaquinaria(){
        return $this->belongsTo(PosMaquinaria::class);
    }
    public function posMarca()
    {
        return $this->belongsTo(\App\Models\Parametros\ParMarca::class, 'par_marca_id'); // Usa el campo correcto
    }
    public function posMantencione()
    {
        return $this->belongsTo(PosMantencione::class, 'pos_mantencione_id');  // Asegúrate de que el campo sea correcto
    }
    
    protected $fillable = [
        'f_entrada',
        'f_salida',
        'pos_m_despacho_id',
        'estado',
        // otros campos que tengas en la tabla
    ];


    // Quitar relación errónea que hacía referencia a sí mismo
    public function posMDMantenciones()
    {
    return $this->hasMany(PosMDMantencione::class, 'pos_mantencion_detalle_id');  // Ajusta el nombre de la columna si es diferente
    }

}
