<?php

namespace App\Models\Pos;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PosMantencione extends Model
{
    use HasFactory;
    /** Tabla real en la BD con prefijo pos_ */
    protected $table = 'pos_mantenciones';
    public function posCliente(){
        return $this->belongsTo(\App\Models\Pos\PosCliente::class);
    }
    public function posMaquinaria(){
        return $this->belongsTo(PosMaquinaria::class);
    }

    public function posMentencionDetalles()
    {
        return $this->hasMany(PosMantencionDetalle::class, 'pos_mantencione_id');
    }
    
    // Alias con nombre correcto para compatibilidad con llamadas que usan posMantencionDetalles
    public function posMantencionDetalles()
    {
        return $this->posMentencionDetalles();
    }
}
