<?php

namespace App\Models\Pos;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PosProveedor extends Model
{
    use HasFactory;
    protected $table = 'pos_proveedores';

    protected $fillable = [
        'rut',
        'razon_social',
        'par_empresa_id'
        // otros campos si los tienes
    ];
    public function parPais()
    {
        return $this->belongsTo(\App\Models\Parametros\ParPais::class);
    }

    public function parRegion()
    {
        return $this->belongsTo(\App\Models\Parametros\ParRegion::class);
    }

    public function parComuna()
    {
        return $this->belongsTo(\App\Models\Parametros\ParComuna::class);
    }

    public function parCiudad()
    {
        return $this->belongsTo(\App\Models\Parametros\ParCiudad::class);
    }

    public function parEmpresa()
    {
        return $this->belongsTo(\App\Models\Parametros\ParEmpresa::class);
    }

    public function parSucursal()
    {
        return $this->belongsTo(\App\Models\Parametros\ParSucursal::class);
    }

    public function user()
    {
        return $this->belongsTo(\App\Models\User::class);
    }

    public function posCompras()
    {
        return $this->hasMany(\App\Models\Contabilidad\ConSiiCompra::class, 'par_proveedor_id');
    }
    
}
