<?php

namespace App\Models\Pos;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PosTraspaso extends Model
{
    use HasFactory;

    protected $fillable = [
        'par_empresa_id',
        'fecha_envio',
        'fecha_eta',
        'fecha_recepcion',
        'fecha_creacion',
        'referencia',
        'observacion',
        'observaciones',
        'usuario_id',
        'estado',
        'folio',
        'e_traspaso',
        'par_sucursal_id'
    ];

    /**
     * Relación a los detalles del traspaso
     * Nombre pedido: pos_traspaso_detalles
     */
    public function pos_traspaso_detalles()
    {
        return $this->hasMany(PosTraspasoDetalle::class, 'pos_traspaso_id');
    }
}
