<?php

namespace App\Models\Pos;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PosTraspasoDetalle extends Model
{
    use HasFactory;
    protected $fillable = [
        'pos_traspaso_id',
        'pos_bodega_articulo_id',
        'pos_bodega_origen_id',
        'pos_bodega_destino_id',
        'cantidad',
        'cantidad_recibida',
        'costo_unitario_fijado',
        'detalle_lotes'
    ];

    /**
     * Relación al PBA principal indicado en la fila (pos_bodega_articulo_id)
     */
    public function pos_bodega_articulo()
    {
        return $this->belongsTo(PosBodegaArticulo::class, 'pos_bodega_articulo_id');
    }

    /**
     * Relación a la PBA origen (pos_bodega_origen_id)
     */
    public function pos_bodega_origen()
    {
        return $this->belongsTo(PosBodegaArticulo::class, 'pos_bodega_origen_id');
    }

    /**
     * Relación a la PBA destino (pos_bodega_destino_id)
     */
    public function pos_bodega_destino()
    {
        return $this->belongsTo(PosBodegaArticulo::class, 'pos_bodega_destino_id');
    }
}
