<?php

namespace App\Models\Pos;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PosVenta extends Model
{
    use HasFactory;
    protected $fillable = [
    'orden',
    'fecha',
    'empresa_id',
    'sucursal_id',
    'observacion',
    'track_id',
    'pdf_url',
    'ven_cliente_id',
    'doc_tributario_id',
    'folio',
    'metodo_id',
    'neto',
    'impuesto',
    'total',
    'usuario_id'
];

    // Relaciones Eloquent necesarias para el controlador
    public function Documento()
    {
        return $this->belongsTo(\App\Models\Contabilidad\ConDocTributario::class, 'con_doc_tributario_id');
    }

    public function Metodo()
    {
        return $this->belongsTo(\App\Models\Pos\PosMetodo::class, 'pos_metodo_id');
    }

    public function Cliente()
    {
        return $this->belongsTo(\App\Models\Pos\PosCliente::class, 'pos_cliente_id');
    }

    // Detalles de la venta
    public function Detalles()
    {
        return $this->hasMany(\App\Models\Pos\PosVentaDetalle::class, 'pos_venta_id');
    }

    // Inventarios relacionados (si aplica)
    public function Inventarios()
    {
        return $this->hasMany(\App\Models\Pos\PosInventario::class, 'pos_venta_id');
    }
}
