<?php

namespace App\Models\Remuneraciones;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RemAsistencia extends Model
{
    protected $table = 'rem_asistencias';

    protected $fillable = [
        'empresa_id',
        'sucursal_id',
        'rem_ficha_id',
        'usuario_id',
        'fecha',
        'rem_labore_id',
        'par_c_costo_id',
        'par_cuartele_id',
        'jh',
        'hora_entrada',
        'hora_salida',
        'horas_extra',
        'rem_trato_id',
        'c_trato',
        'bono_extra',
        'observaciones',
    ];

    protected $casts = [
        'fecha' => 'date',
        'hora_entrada' => 'datetime:H:i:s',
        'hora_salida' => 'datetime:H:i:s',
        'horas_extra' => 'decimal:2',
        'c_trato' => 'decimal:2',
        'bono_extra' => 'decimal:2',
        'jh' => 'boolean',
    ];

    // Relaciones
    public function empresa()
    {
        return $this->belongsTo(ParEmpresa::class);
    }

    public function sucursal()
    {
        return $this->belongsTo(ParSucursal::class);
    }

    public function ficha()
    {
        return $this->belongsTo(ParRemFicha::class, 'rem_ficha_id');
    }

    public function usuario()
    {
        return $this->belongsTo(User::class);
    }

    public function labore()
    {
        return $this->belongsTo(RemLabore::class, 'rem_labore_id');
    }

    public function centroCosto()
    {
        return $this->belongsTo(ParCCosto::class, 'par_c_costo_id');
    }

    public function cuartel()
    {
        return $this->belongsTo(ParCuartel::class, 'par_cuartele_id');
    }

    public function trato()
    {
        return $this->belongsTo(RemTrato::class, 'rem_trato_id');
    }
}
