<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TGRemuneracione extends Model
{
    use HasFactory;
    protected $fillable = [
        't_periodo_id',       // Agregar el campo t_periodo_id aquí
        'empresa_id',
        't_p_remuneracione_id',
        'validador',
        // Agrega otros campos si es necesario
    ];
    public function TPRemuneracione(){
        return $this->belongsTo(TPRemuneracione::class);
    }
    public function Empresa(){
        return $this->belongsTo(Empresa::class);
    }
    public function parPeriodo(){
        return $this->belongsTo(\App\Models\Parametros\ParPeriodo::class, 'par_periodo_id');
    }
    public function TTarea(){
        return $this->belongsTo(TTarea::class);
    }
}
