<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
    'rol_id',
    'par_empresa_id',
    'n_empresa',
    'n_sucursal',
    'sucursal_id',
    'pos_bodega_id',
    'nombre',
    's_nombre',
    'a_paterno',
    'a_materno',
    'username',
    'email',
    'password',
    'trabajador_id',
    'tipo',
    't_periodo_id',
    'menu',
    'estado',
];


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',

    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [

    ];
    public function posBodega(){
        return $this->belongsTo(\App\Models\Pos\PosBodega::class);
    }
    public function parEmpresa(){
        return $this->belongsTo(\App\Models\Parametros\ParEmpresa::class);
    }
    public function parSucursal(){
        return $this->belongsTo(\App\Models\Parametros\ParSucursal::class);
    }
    public function Role(){
        return $this->belongsTo(Role::class);
    }
    public function UserEmpresa(){
        return $this->belongsTo(UserEmpresa::class);
    }
   
    public function posCliente(){
        return $this->hasMany(\App\Models\Pos\PosCLiente::class);
    }
    public function  ClienteUser(){
        return $this->hasMany(ClienteUser::class);
    }
    
    
}
