<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Services\SIIService;
use Illuminate\Routing\Router;
use Laravel\Sanctum\Http\Middleware\EnsureFrontendRequestsAreStateful;

class AppServiceProvider extends ServiceProvider
{
    public function register()
    {
        // Si no estás usando auto-discovery, registra el servicio
        $this->app->singleton(SIIService::class, function ($app) {
            return new SIIService();
        });
    }

    public function boot()
    {
        // Si ROUTES_PROTECTED está desactivado, quitamos el middleware
        // stateful de Sanctum del grupo 'api' para evitar requerir CSRF
        // y cookies de sesión en rutas API.
        if (!config('routes.protected')) {
            $router = $this->app->make(Router::class);
            $groups = method_exists($router, 'getMiddlewareGroups') ? $router->getMiddlewareGroups() : [];
            if (isset($groups['api']) && is_array($groups['api'])) {
                $apiGroup = array_values(array_filter($groups['api'], function ($m) {
                    return $m !== EnsureFrontendRequestsAreStateful::class;
                }));
                // Re-definir el grupo 'api' sin el middleware stateful
                $router->middlewareGroup('api', $apiGroup);
            }
        }
    }
}