<?php

namespace App\Services;

use GuzzleHttp\Client;

class SIIService
{
    // Obtener el token de acceso
    public function obtenerToken($rut, $clave)
    {
        $url = 'https://api.sii.cl/oauth/token';  // URL para obtener el token

        $client = new Client();
        $response = $client->post($url, [
            'form_params' => [
                'grant_type' => 'password',
                'client_id' => 'tu_client_id', // Reemplaza con tu Client ID
                'client_secret' => 'tu_client_secret', // Reemplaza con tu Client Secret
                'username' => $rut,
                'password' => $clave,
            ]
        ]);

        $data = json_decode($response->getBody(), true);
        return $data['access_token'];  // Retorna el token de acceso
    }

    // Obtener las compras del SII
    public function obtenerCompras($rutCliente, $dvCliente, $fechaDesde, $fechaHasta, $clave)
    {
        // Obtener el token
        $token = $this->obtenerToken($rutCliente, $clave);

        // URL del servicio para obtener las compras
        $url = "https://maullin.sii.cl/DTEWS/QueryEstDte.jws?WSDL"; // URL actualizada para el servicio SOAP

        // Cliente Guzzle para la solicitud HTTP
        $client = new Client();
        $response = $client->request('GET', $url, [
            'headers' => [
                'Authorization' => "Bearer $token",
                'Accept' => 'application/json',
            ]
        ]);

        // Decodificar la respuesta JSON
        return json_decode($response->getBody(), true);
    }
}