<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;

class SimpleApiService
{
    protected $apiKey;
    protected $baseUrl;

    public function __construct()
    {
        $this->apiKey = config('services.simpleapi.key');
        $this->baseUrl = 'https://api.simpleapi.cl/api/';
    }

    public function emitirDTE(array $data)
    {
        return Http::withHeaders([
            'apikey' => $this->apiKey,
            'Accept' => 'application/json',
        ])->post($this->baseUrl . 'dte/documento', $data);
    }

    public function estadoDocumento($trackId)
    {
        return Http::withHeaders([
            'apikey' => $this->apiKey,
        ])->get($this->baseUrl . "dte/estado/{$trackId}");
    }
}