<?php

use App\Models\Parametros\ParSucursal as ParSucursal;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CafController;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\CajaController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\Parametros\ParSucursalController;

use App\Http\Controllers\CertificadoController;

use App\Http\Controllers\UserEmpresaController;
use App\Http\Controllers\Parametros\ParEmpresaController;
use App\Http\Controllers\Contabilidad\ConSiiHVentaController;
use App\Http\Controllers\Contabilidad\ConSiiVentaController;
use App\Http\Controllers\Contabilidad\ConSiiComprasController;
use App\Http\Controllers\Contabilidad\ConSiiHCompraController;
use App\Http\Controllers\Contabilidad\ConPreLibVentaController;
use App\Http\Controllers\Contabilidad\ConLibroFoliadoController;
use App\Http\Controllers\Contabilidad\ConPreLibCompraController;
use App\Http\Controllers\Contabilidad\ConSiiPendienteController;
use App\Http\Controllers\TablaDocComprasController;
use App\Http\Controllers\Contabilidad\ConPreLibHCompraController;
use App\Http\Controllers\Contabilidad\ConSiiCompraImportController;
use App\Models\RemAfp;


use App\Http\Controllers\Contabilidad\ConCunentaController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


// Dashboard Panguimaq
// La protección de rutas se controla exclusivamente desde .env via ROUTES_PROTECTED
// (ROUTES_PROTECTED=true -> rutas protegidas con auth:sanctum).
$apiMiddleware = config('routes.protected') ? ['auth:sanctum'] : [];

Route::middleware($apiMiddleware)->group(function () {

     // Logout: protegido cuando ROUTES_PROTECTED=true
     Route::post('/logout', function (Request $request) {
          if (method_exists($request->user(), 'currentAccessToken')) {
               $request->user()->currentAccessToken()->delete();
          }
          return response()->json(['message' => 'Token revocado']);
     });

     //Parametros
     Route::apiResource('/parPaises', App\Http\Controllers\Parametros\ParPaisController::class);
     Route::get('/parRegion/filtro', [App\Http\Controllers\Parametros\ParRegionController::class, 'Filtro']);
     Route::apiResource('/parRegiones', App\Http\Controllers\Parametros\ParRegionController::class);
     Route::apiResource('/parComunas', App\Http\Controllers\Parametros\ParComunaController::class);
     Route::get('/parComuna/filtro', [App\Http\Controllers\Parametros\ParComunaController::class, 'Filtro']);
     Route::apiResource('/parCiudades', App\Http\Controllers\Parametros\ParCiudadController::class);
     Route::get('/parCiudad/filtro', [App\Http\Controllers\Parametros\ParCiudadController::class, 'Filtro']);

     //Parametros-Empresa

     Route::apiResource('/parEmpresas', App\Http\Controllers\Parametros\ParEmpresaController::class);
     
     Route::get('/parEmpresa/filtro', [App\Http\Controllers\Parametros\ParEmpresaController::class, 'filtro']);
     Route::get('/parEmpresa/libro/filtro', [App\Http\Controllers\Parametros\ParEmpresaController::class, 'filtroLibro']);

     //Parametros-Sucursal

     Route::apiResource('/parSucursales', App\Http\Controllers\Parametros\ParSucursalController::class);
     Route::get('/parSucursal/empresa', [App\Http\Controllers\Parametros\ParSucursalController::class, 'Empresa']);

     //Parametros-Socios
     
     Route::apiResource('/parSocios', App\Http\Controllers\Parametros\ParSocioController::class);
     Route::get('/parSocio/filtro', [App\Http\Controllers\Parametros\ParSocioController::class, 'Filtro']);

     //Parametros-Representantes

     Route::apiResource('/parRepresentantes', App\Http\Controllers\Parametros\ParRepresentanteController::class);
     Route::get('/parRepresentante/filtro', [App\Http\Controllers\Parametros\ParRepresentanteController::class, 'Filtro']);

     //Parametros-Varios


     //Pos

     Route::apiResource('/posCategorias', App\Http\Controllers\Pos\PosCategoriaController::class);

   


     //Remuneraciones
   
  
     Route::get('/posBodega/empresa', [App\Http\Controllers\Pos\PosBodegaController::class, 'BodegaEmpresa']);

     Route::get('posBodegas', [App\Http\Controllers\Pos\PosBodegaController::class, 'index']);

    

     Route::post('/importar-ventas/{nombreArchivo}', [ConSiiVentaController::class, 'importarVentasDesdeCSV']);
     Route::post('/importar-ventas-resumen/{nombreArchivo}', [ConSiiVentaController::class, 'importarResumenBoletaDesdeCSV']);
     Route::get('/conSiiPendientes/filtro', [App\Http\Controllers\Contabilidad\ConSiiPendienteController::class, 'Filtro']);

     Route::get('parPeriodoEmpresas/', [App\Http\Controllers\Parametros\ParPeriodoEmpresaController::class, 'index']);
    
     Route::get('parPeriodoEmpresas/{id}', [App\Http\Controllers\Parametros\ParPeriodoEmpresaController::class, 'show']);
    
     Route::post('parPeriodoEmpresas/', [App\Http\Controllers\Parametros\ParPeriodoEmpresaController::class, 'store']);
     Route::delete('parPeriodoEmpresas/{id}', [App\Http\Controllers\Parametros\ParPeriodoEmpresaController::class, 'destroy']);

          // Rutas adicionales
     Route::get('parPeriodoEmpresas/filtro', [App\Http\Controllers\Parametros\ParPeriodoEmpresaController::class, 'Filtro']);
     Route::get('parPeriodoEmpresas/filtroActivo', [App\Http\Controllers\Parametros\ParPeriodoEmpresaController::class, 'filtroActivo']);


     Route::get('/Dpanguimaq/filtroMensual', 'DPanguimaqController@resumenMensual');
     Route::get('/Dpanguimaq/filtroMensualATMaquinarias', 'DPanguimaqController@resumenMensualATmaquinarias');
     Route::get('/Dpanguimaq/filtroMensualACTMaquinarias', 'DPanguimaqController@resumenMensualACTmaquinarias');
     Route::get('/Dpanguimaq/filtroMensualMantencion', 'DPanguimaqController@resumenMensualMantencion');
     Route::get('/Dpanguimaq/filtroMensualMantencionTMaquinarias', 'DPanguimaqController@resumenMensualMantencionTMaquinarias');
     Route::get('/Dpanguimaq/filtroMensualMantencionCTMaquinarias', 'DPanguimaqController@resumenMensualMantencionCTMaquinarias');



     Route::put('/conPreLibCompra/actualizarFacturas', [ConPreLibCompraController::class, 'actualizarFacturas']);

     //Cosfiguracion



     //Foliar Libros
     Route::get('/conFolioLibro/filtro', [App\Http\Controllers\Contabilidad\ConFolioLibroController::class, 'filtro']);
     



     //Libro Diario
     Route::get('/conLibroFoliados/filtro/anual', [App\Http\Controllers\Contabilidad\ConLibroFoliadoController::class, 'filtroLDiarioAnual']);
     Route::get('/conLibroFoliados/filtro/mensual', [App\Http\Controllers\Contabilidad\ConLibroFoliadoController::class, 'filtroLDiarioMensual']);
     Route::post('/conLibroFoliados/foliarAnual', [ConLibroFoliadoController::class, 'foliarAnual']);
     


     //Contabilidad

     //Sii Compras
     Route::get('/consiicompras/filtro', [App\Http\Controllers\Contabilidad\ConSiiComprasController::class, 'Filtro']);
     Route::get('/prelibcompras/filtro', [App\Http\Controllers\Contabilidad\ConPreLibCompraController::class, 'Filtro']);
     Route::get('/consiicompras/rendicion/filtro', [App\Http\Controllers\Contabilidad\ConSiiComprasController::class, 'filtroRendicion']);
     Route::get('/prelibcompras/filtroCompra', [App\Http\Controllers\Contabilidad\ConPreLibCompraController::class, 'FiltroCompra']);
     Route::get('/prelibcompras/filtroFactura', [App\Http\Controllers\Contabilidad\ConPreLibCompraController::class, 'FiltroFactura']);

     //Sii Venta

     // ✅ Esto permitirá recibir peticiones POST desde tu script Node.js:
     Route::post('/importar-compras/{archivo}', [App\Http\Controllers\Contabilidad\ConSiiComprasController::class, 'importarComprasDesdeCSV']);

     Route::get('/consiiventas/filtro', [App\Http\Controllers\Contabilidad\ConSiiVentaController::class, 'Filtro']);
     Route::get('/prelibventas/filtro', [App\Http\Controllers\Contabilidad\ConPreLibVentaController::class, 'Filtro']);

     //Honorarios Ventas
     Route::post('/importar-hventas/{nombreArchivo}', [App\Http\Controllers\Contabilidad\ConSiiHVentaController::class, 'importarVentasDesdeCSV'])
          ->where('nombreArchivo', '.*');

     Route::post('/importar-htventas/{nombreArchivo}', [App\Http\Controllers\Contabilidad\ConSiiHVentaController::class, 'importarVentasDesdeHTMLVET'])
          ->where('nombreArchivo', '.*');
     Route::get('/consiihventas/filtro', [App\Http\Controllers\Contabilidad\ConSiiHVentaController::class, 'Filtro']);
     Route::get('/prelibhventas/filtro', [App\Http\Controllers\Contabilidad\ConPreLibHVentaController::class, 'Filtro']);

     //Honorarios Compras
     Route::post('/importar-hcompras/{nombreArchivo}', [App\Http\Controllers\Contabilidad\ConSiiHCompraController::class, 'importarComprasDesdeCSV'])
          ->where('nombreArchivo', '.*');
     Route::post('/importar-hctcompras/{nombreArchivo}', [App\Http\Controllers\Contabilidad\ConSiiHCompraController::class, 'importarComprasDesdeHTMLVET'])
          ->where('nombreArchivo', '.*');
     Route::get('/consiihcompras/filtro', [App\Http\Controllers\Contabilidad\ConSiiHCompraController::class, 'Filtro']);
     Route::get('/prelibhcompras/filtro', [App\Http\Controllers\Contabilidad\ConPreLibHCompraController::class, 'Filtro']);
     Route::get('/prelibhcompras/filtroCompra', [App\Http\Controllers\Contabilidad\ConPreLibHCompraController::class, 'FiltroCompra']);
     Route::get('/prelibhcompras/filtroFactura', [App\Http\Controllers\Contabilidad\ConPreLibHCompraController::class, 'FiltroFactura']);
     Route::put('/prelibhcompras/actualizarFacturas', [App\Http\Controllers\Contabilidad\ConPreLibHCompraController::class, 'actualizarFacturas']);

     //Sii Centralizacion Ventas
     Route::get('/prelibventas/filtroVenta', [App\Http\Controllers\Contabilidad\ConPreLibVentaController::class, 'FiltroVenta']);
     Route::get('/prelibventas/filtroFactura', [App\Http\Controllers\Contabilidad\ConPreLibVentaController::class, 'FiltroFactura']);
     Route::put('/conPreLibVenta/actualizarMasivoPorCliente', [App\Http\Controllers\Contabilidad\ConPreLibVentaController::class, 'actualizarMasivoPorCliente']);
     Route::put('/conPreLibVenta/actualizarFacturas', [App\Http\Controllers\Contabilidad\ConPreLibVentaController::class, 'actualizarFacturas']);

     //Pendiente Recepcion
     Route::post('/importar-pendientes/{archivo}', [App\Http\Controllers\Contabilidad\ConSiiPendienteController::class, 'importarPendientesDesdeCSV']);
     Route::post('/desPendientes', [App\Http\Controllers\Contabilidad\ConSiiPendienteController::class, 'descargar']);
     Route::post('/actualizarPendientes', [App\Http\Controllers\Contabilidad\ConSiiPendienteController::class, 'actualizarPendientes']);
     Route::post('/actualizarPendientes2', [App\Http\Controllers\Contabilidad\ConSiiPendienteController::class, 'descargar']);

     Route::post('/aceptar', [App\Http\Controllers\Contabilidad\ConSiiPendienteController::class, 'aceptar']);



     //Plan de Cuentas
     Route::get('/conFormularioDetalles/filtro', [App\Http\Controllers\Contabilidad\ConFormularioDetalleController::class, 'Filtro']);
     Route::get('/conAAutomaticos/filtro', [App\Http\Controllers\Contabilidad\ConAAutomaticoController::class, 'Filtro']);

     //Asignación de cuentas negerales
     Route::get('/conimpuestocuentas/filtro', [App\Http\Controllers\Contabilidad\ConImpuestoCuentaController::class, 'Filtro']);
     Route::get('/conCuentaSiiCompra/filtro', [App\Http\Controllers\Contabilidad\ConCuentaSiiCompraController::class, 'Filtro']);
     Route::get('/conCuentaSiiVenta/filtro', [App\Http\Controllers\Contabilidad\ConCuentaSiiVentaController::class, 'Filtro']);
     Route::get('/conCuentaSiiHCompra/filtro', [App\Http\Controllers\Contabilidad\ConCuentaSiiHCompraController::class, 'Filtro']);
     Route::get('/conCuentaSiiHVenta/filtro', [App\Http\Controllers\Contabilidad\ConCuentaSiiHVentaController::class, 'Filtro']);
     Route::get('/conCuentaGeneral/filtro', [App\Http\Controllers\Contabilidad\ConCuentaGeneralController::class, 'Filtro']);
     Route::get('/conVoucher/filtro', [App\Http\Controllers\Contabilidad\ConVoucherController::class, 'Filtro']);
     Route::get('/conVoucher/balance', [App\Http\Controllers\Contabilidad\ConVoucherController::class, 'Balance']);

     //Centro de Costos
     Route::get('/parccostos/filtro', [App\Http\Controllers\Parametros\ParCCostoController::class, 'Filtro']);

     //Cuarteles
     Route::get('/parCuarteles/filtro', [App\Http\Controllers\Parametros\ParCuartelController::class, 'Filtro']);

     //Dasboard Contabilidad
     Route::get('/impuestos/filtro', 'DashboardController@Impuesto');

     //Remuneraciones

     //Colaboradores
     Route::get('/remFichas/empresa', [App\Http\Controllers\Remuneraciones\RemFichaController::class, 'Empresa']);

     //Registro asistencia
     Route::get('/remLabores/filtro', [App\Http\Controllers\Remuneraciones\RemLaboreController::class, 'Filtro']);
     Route::get('/remAsistencias/empresa', [App\Http\Controllers\Remuneraciones\RemAsistenciaController::class, 'Empresa']);


     Route::apiResource('/remFichas', App\Http\Controllers\Remuneraciones\RemFichaController::class);

     Route::get('/remFicha/ficha', [App\Http\Controllers\Remuneraciones\RemFichaController::class, 'filtro']);
     Route::get('/remFicha/empresa', [App\Http\Controllers\Remuneraciones\RemFichaController::class, 'empresa']);
     Route::get('/remFicha/empresa1', [App\Http\Controllers\Remuneraciones\RemFichaController::class, 'empresa1']);
     Route::get('/remFicha/sucursal', [App\Http\Controllers\Remuneraciones\RemFichaController::class, 'sucursal']);



     Route::post('/subir-libro-ventas', [ConSiiVentaController::class, 'subirLibro']);

     Route::put('/conPreLibCompra/actualizarMasivoPorProveedor', [ConPreLibCompraController::class, 'actualizarMasivoPorProveedor']);

     //Maquinarias
     Route::get('/Maquinarias/filtro', 'MaquinariaController@Filtro2');

     Route::get('/posMaquinarias/empresa', 'MaquinariaController@Filtro3');

     Route::post('/descargar', [App\Http\Controllers\Contabilidad\ConSiiComprasController::class, 'descargar']);
     Route::post('/descargarVentas', [App\Http\Controllers\Contabilidad\ConSiiVentaController::class, 'descargar']);
     Route::post('/descargarhc', [App\Http\Controllers\Contabilidad\ConSiiHCompraController::class, 'descargar']);
     Route::post('/descargarhv', [App\Http\Controllers\Contabilidad\ConSiiHVentaController::class, 'descargar']);

          // Emisión de token para scripts (usar SERVICE_TOKEN_SECRET en .env)
          Route::post('/service-token', [App\Http\Controllers\ServiceTokenController::class, 'issue']);


     Route::post('/subircompras', [ConSiiComprasController::class, 'store']);


     Route::get('/conCategoriaCuenta/filtro', [App\Http\Controllers\Contabilidad\ConCategoriaCuentasController::class, 'Filtro']);
     Route::get('/conCuentaMadre/filtro', [App\Http\Controllers\Contabilidad\ConCuentaMadreController::class, 'Filtro']);
          Route::get('/conCuenta/filtro', [App\Http\Controllers\Contabilidad\ConCuentasController::class, 'Filtro']);

     Route::get('/pagoProveedores', [App\Http\Controllers\Contabilidad\ConSubCuentaController::class, 'pagoProveedores']);


     /* Fin Facturación Electronica*/

     Route::get('/siicompras', 'ComprasController@obtenerCompras');


     Route::post('/template', 'ArchivoDoctoController@Template');

     Route::get('/liquidaciones/{liquidacion}/liquidacion', 'LiquidacionController@descarga');
     Route::get('/liquidacionDocts/{liquidaciondocto}/liquidacion', 'LiquidacionDoctoController@descarga');
     Route::post('/liquidacionDoct/liquidacion/{liquidacion}', 'LiquidacionDoctoController@store');
     Route::get('users/export/', [UserController::class, 'export'])->name('export');


     

     Route::get('/articuloImages/articulo/{articulo}', 'ArticuloImageController@show');
     Route::post('/articuloImages/articulo/{articulo}', 'ArticuloImageController@store');
     Route::get('/archivos/archivo', 'ArchivoController@trabajador');
     Route::get('/archivos/contrato', 'ArchivoController@FiltroContrato');
     Route::get('/archivos/registro', 'ArchivoController@FiltroRegistro');
     Route::get('/archivos/area', 'ArchivoController@FiltroArea');
     Route::get('/rfacturacion/filtro', 'RFacturacioneController@Filtro');
     Route::get('/facturaciones/filtro', 'FacturacioneController@Filtro');
     Route::get('/facturaciones/filtro2', 'FacturacioneController@Filtro2');
     Route::get('/usersEmpresa/usuario', 'UserEmpresaController@Usuario');
     Route::get('/usersSucursal/usuario', 'UserSucursalController@Usuario');
     Route::get('/usersSucursal/empresa', 'UserSucursalController@Empresa');

     Route::get('/posBodega/sucursal', [App\Http\Controllers\Pos\PosBodegaController::class, 'Bodega']);

   
     Route::get('/area/filtro', 'TipoArchivoController@area');

     Route::get('/formularios/formulario', 'CFPeriodoController@Filtro');
     Route::get('/cfdetalles', 'CFDetalleController@Filtro');

     Route::get('/templates/filtro', 'TemplateController@Filtro');
     Route::get('/templates/empresa', 'TemplateController@Empresa');
     Route::get('/templates/id', 'TemplateController@id');

     Route::get('/posArriendoDetalles/filtro', [App\Http\Controllers\Pos\PosArriendoDetalleController::class, 'Filtro']);
     Route::get('/posArriendoDetalles/filtro1', [App\Http\Controllers\Pos\PosArriendoDetalleController::class, 'Filtro1']);
     Route::get('/posArriendoDetalle/filtro2', [App\Http\Controllers\Pos\PosArriendoDetalleController::class, 'Filtro2']);
     Route::get('/posArriendos/filtro2', [App\Http\Controllers\Pos\PosArriendoController::class, 'Filtro2']);
     Route::get('/posMDMantenciones/filtro', [App\Http\Controllers\Pos\PosMDMantencioneController::class, 'Filtro']);
     // duplicate filtro2 route removed (handled above by Pos\PosArriendoDetalleController)
     Route::get('/posMantencionDetalles/filtro2', [App\Http\Controllers\Pos\PosMantencionDetalleController::class,'Filtro2']);
     Route::get('/posMaquinaria/filtro', [App\Http\Controllers\Pos\PosMaquinariaController::class, 'Filtro']);
     Route::get('/posMaquinaria/filtro1', [App\Http\Controllers\Pos\PosMaquinariaController::class, 'Filtro1']);
     Route::get('/posMaquinaria/filtro3', [App\Http\Controllers\Pos\PosMaquinariaController::class, 'Filtro3']);
     Route::get('/mantencionDetalles/filtro', 'MantencionDetalleController@Filtro');

     Route::post('/save-ventas', [TablaDocComprasController::class, 'store']);

     Route::get('/reportes/recepciones/{aRecepcione}', [App\Http\Controllers\Pos\PosARecepcioneController::class, 'imprimirTicket']);
     Route::get('/reportes/arriendo/{arriendo}', [App\Http\Controllers\Pos\PosArriendoController::class, 'imprimirTicket']);
     Route::get('/reportes/mantencion/ingreso/{mantencione}', [App\Http\Controllers\Pos\PosMantencioneController::class, 'imprimirTicket']);
     Route::get('/reportes/mantencion/despacho/{mDespacho}', [App\Http\Controllers\Pos\PosMDespachoController::class, 'imprimirTicket']);


     Route::get('/rCAsistencias/filtro', 'RCAsistenciaController@Filtro');
     Route::get('/rCAsistencias/filtro2', 'RCAsistenciaController@Filtro2');
     Route::get('/rCAsistencias/filtroSalida', 'RCAsistenciaController@filtroSalida');
     //Trabajadores
     Route::get('/tPeriodoTrabajadore/filtro', 'TPeriodoTrabajadoreController@Filtro');
     
     Route::get('/rInasistencias/filtro', 'RInasistenciaController@Filtro');
     Route::get('/rDetalleLibros/filtro', 'RDetalleLibroController@procesar');

     Route::get('/tPPrevisiones/filtro', 'TPPrevisioneController@Filtro');

     Route::get('/sControles/filtro', 'SControleController@Filtro');
     //Procesos
     Route::get('/rLibros/filtro', 'RLibroController@Filtro');
     Route::get('/rDetalleLibros/filtro', 'RDetalleLibroController@Filtro');
     Route::get('/rDetalleLibros/porcesar', 'RDetalleLibroController@procesar');

     Route::get('/rDetalleLibros/liquidacion', 'RDetalleLibroController@liquidacion');

     //Gestion del Contador
     Route::get('/tPagoImpuesto/filtro', 'TPagoImpuestoController@Filtro');
     Route::get('/tPermRoles/filtro', 'TPermRoleController@Filtro');
     Route::get('/tGHonorario/filtro', 'TGHonorarioController@Filtro');
     Route::get('/tGIngreso/filtro', 'TGIngresoController@Filtro');
     Route::get('/tGRemuneracione/filtro', 'TGRemuneracioneController@Filtro');

     Route::post('/archivoDoctos/archivo/{archivo}', 'ArchivoDoctoController@store');
     Route::post('/respaldoDocto/archivo/{respaldo}', 'RespaldoDoctoController@store');
     Route::post('/respaldoFacturaciones/archivo/{rFacturacione}', 'RespaldoFacturacioneController@store');
     Route::get('/respaldo/formulario29', 'RespaldoController@Formulario29');
     Route::get('/respaldo/prevencion', 'RespaldoController@Prevencion');






     Route::post('/fichaImages/ficha/{ficha}', 'FichaImageController@store');
     Route::get('/dashboard', 'DashboardController@info');
     Route::get('/dashboardgas', 'DashboardgasController@info');
     
     Route::get('/liquidaciones/liquidacion', 'LiquidacionController@ficha');
     Route::get('/liquidaciones/liquidacion2', 'LiquidacionController@trabajador2');
    
     Route::get('/liquidacionDocts/liquidacion/{liquidacion}', 'LiquidacionDoctoController@show');
     Route::get('/parProveedors/selectProveedor', 'ParProveedorController@selectProveedor');
     Route::get('/inventarios/inventario', 'InventarioController@inventario');
     Route::get('/inventarios/categoria', 'InventarioController@kardex3');
     Route::get('/detellepedidos/pedido', 'PedidoDetalleController@pedidos');
    
     Route::get('/reportes/pedidos/{pedido}', 'PedidoController@pdf');
    
     Route::get('/tesorerias/cajadia/', 'TesoreriaController@cajadia');
     Route::get('/tesorerias/cajadia2/', 'TesoreriaController@cajadia2');
    

     

     Route::apiResource('/conLibroFoliados', App\Http\Controllers\Contabilidad\ConLibroFoliadoController::class);

     //Parametros
     Route::apiResource('/conPAuxiliar', App\Http\Controllers\Contabilidad\ConPAuxiliaresController::class);
     Route::apiResource('/conTipoCuentas', App\Http\Controllers\Contabilidad\ConTipoCuentasController::class);
     Route::apiResource('/conCategoriaCuentas', App\Http\Controllers\Contabilidad\ConCategoriaCuentasController::class);
     Route::apiResource('/conTVouchers', App\Http\Controllers\Contabilidad\ConTVoucherController::class);
     Route::apiResource('/conVouchers', App\Http\Controllers\Contabilidad\ConVoucherController::class);
     Route::apiResource('/conCuentaSiiCompras', App\Http\Controllers\Contabilidad\ConCuentaSiiCompraController::class);
     Route::apiResource('/conCuentaSiiVentas', App\Http\Controllers\Contabilidad\ConCuentaSiiVentaController::class);
     Route::get('/conCategoriaCuenta/filtro', [App\Http\Controllers\Contabilidad\ConCategoriaCuentasController::class, 'Filtro']);
     Route::apiResource('conImpuestoCuentas', App\Http\Controllers\Contabilidad\ConImpuestoCuentaController::class);
     Route::apiResource('conCuentaGenerals', App\Http\Controllers\Contabilidad\ConCuentaGeneralController::class);
     Route::apiResource('conImpuestoAnuals', App\Http\Controllers\Contabilidad\ConImpuestoAnualController::class);

    
     //Periodos
     Route::get('/parPeriodoEmpresas-filtro', [App\Http\Controllers\Parametros\ParPeriodoEmpresaController::class, 'Filtro']);
     Route::get('/parPeriodoEmpresas-filtroActivo', [App\Http\Controllers\Parametros\ParPeriodoEmpresaController::class, 'filtroActivo']);

     Route::apiResource('/parPeriodos', App\Http\Controllers\Parametros\ParPeriodoController::class);

     Route::apiResource('/conCuentaSiiVentas', App\Http\Controllers\Contabilidad\ConCuentaSiiVentaController::class);

     Route::apiResource('/eProcesos', 'EProcesoController');
     Route::apiResource('/areas', 'AreaController');
     Route::apiResource('/conCuentaSiiHCompras', App\Http\Controllers\Contabilidad\ConCuentaSiiHCompraController::class);
     Route::apiResource('/conCuentaSiiHVentas', App\Http\Controllers\Contabilidad\ConCuentaSiiHVentaController::class);
     Route::apiResource('/conSiiPendientes', App\Http\Controllers\Contabilidad\ConSiiPendienteController::class);

     //Formularios
     Route::apiResource('/conFormularios', App\Http\Controllers\Contabilidad\ConFormularioController::class);
     Route::apiResource('/conParFormularios', App\Http\Controllers\Contabilidad\ConParFormularioController::class);
     Route::apiResource('/conFormularioDetalles', App\Http\Controllers\Contabilidad\ConFormularioDetalleController::class);







     //Procesos Contabilidad
     Route::apiResource('/conSiiCompras', App\Http\Controllers\Contabilidad\ConSiiComprasController::class);
     Route::apiResource('/conFolioVouchers', App\Http\Controllers\Contabilidad\ConFolioVoucherController::class);
     Route::apiResource('/conLibroDiario', App\Http\Controllers\Contabilidad\ConLibroDiarioController::class);
     Route::apiResource('/conProveedorCuentas', App\Http\Controllers\Contabilidad\ConProveedorCuentaController::class);

     Route::apiResource('/conImpuestos', App\Http\Controllers\Contabilidad\ConImpuestoController::class);


     Route::apiResource('/conClienteCuentas', App\Http\Controllers\Contabilidad\ConClienteCuentaController::class);

     //Centralización Compras
     Route::apiResource('/conPreLibCompras', App\Http\Controllers\Contabilidad\ConPreLibCompraController::class);

     //Centralización Ventas
     Route::apiResource('/conPreLibVentas', App\Http\Controllers\Contabilidad\ConPreLibVentaController::class);

     //Centralización Honorarios Compras
     Route::apiResource('/conPreLibHCompras', App\Http\Controllers\Contabilidad\ConPreLibHCompraController::class);
     //Centralización Honorarios Ventas
     Route::apiResource('/conPreLibHVentas', App\Http\Controllers\Contabilidad\ConPreLibHVentaController::class);

     //Cuentas
     Route::apiResource('/conCuentaMadres', App\Http\Controllers\Contabilidad\ConCuentaMadreController::class);
     Route::apiResource('/conCuentas', App\Http\Controllers\Contabilidad\ConCuentasController::class);
     Route::apiResource('/conSubCuentas', App\Http\Controllers\Contabilidad\ConSubCuentaController::class);
     Route::apiResource('/conAAutomaticos', App\Http\Controllers\Contabilidad\ConAAutomaticoController::class);
     Route::apiResource('/conAAutDetalles', App\Http\Controllers\Contabilidad\ConAAutDetalleController::class);

     //Libro SII
     Route::apiResource('/libroSiiCompras', 'LibroSiiComprasController');

     //Trabajadores
     Route::apiResource('/liquidaciones', 'LiquidacionController');
     Route::apiResource('/tPermRoles', 'TPermRoleController');
     Route::apiResource('/tPeriodoTrabajadores', 'TPeriodoTrabajadoreController');
    
     Route::apiResource('/rInasistencias', 'RInasistenciaController');
     Route::apiResource('/archivos', 'ArchivoController');
     Route::apiResource('/rFacturaciones', 'RFacturacioneController');
     Route::apiResource('/respaldos', 'RespaldoController');
     Route::apiResource('/remSexos', 'RemSexoController');
     Route::apiResource('/remNacionalidades', 'RemNacionalidadeController');
     Route::apiResource('/remEstadoCiviles', 'RemEstadoCivileController');

     Route::apiResource('/sControles', 'SControleController');
     Route::apiResource('/sCentros', 'SCentroController');
     Route::apiResource('/tPermRoles', 'TPermRoleController');

     Route::apiResource('/cFormularios', 'CFormularioController');
     Route::apiResource('/cFPeriodos', 'CFPeriodoController');
     Route::apiResource('/cFDetalles', 'CFDetalleController');

     //Configuracion

     Route::apiResource('/posEstatus', App\Http\Controllers\Pos\PosEstatuController::class);
     

     Route::apiResource('/arriendoDetalles', App\Http\Controllers\Pos\PosArriendoDetalleController::class);

     //Maquinaria

     Route::apiResource('/posArriendos', App\Http\Controllers\Pos\PosArriendoController::class);
     Route::apiResource('/posMantenciones', App\Http\Controllers\Pos\PosMantencioneController::class);

     //Ventas


     Route::apiResource('/posArecepciones', App\Http\Controllers\Pos\PosARecepcioneController::class);

     Route::apiResource('/posMantencionDetalles', App\Http\Controllers\Pos\PosMantencionDetalleController::class);

     Route::apiResource('/posMDMantenciones', App\Http\Controllers\Pos\PosMDMantencioneController::class);

     Route::apiResource('/posMDespachos', App\Http\Controllers\Pos\PosMDespachoController::class);



     //Remuneraciones
     Route::apiResource('/rTipoInasistencias', 'RTipoInasistenciaController');

     Route::apiResource('/rCAsistencias', 'RCAsistenciaController');

     Route::apiResource('/menus', 'MenuController');

     
   

     //
     Route::apiResource('/tPPrevisiones', 'TPPrevisioneController');
     //Procesos Remuneraciones
     Route::apiResource('/rLibros', 'RLibroController');
     Route::apiResource('/rDetalleLibros', 'RDetalleLibroController');

     Route::apiResource('/certificados', 'CertificadoController');

     Route::apiResource('/tipoArchivos', 'TipoArchivoController');
     Route::apiResource('/parAnios', App\Http\Controllers\Parametros\ParAnioController::class);
     Route::apiResource('/parMeses', App\Http\Controllers\Parametros\ParMeseController::class);


     Route::apiResource('/templates', 'TemplateController');

     //Cargas Automaticas
     Route::apiResource('/tImpAutomaticos', 'TImpAutomaticoController');
     Route::apiResource('/tRemuAutomaticos', 'TRemuAutomaticoController');



     //Tipo de Pagos Legales
     Route::apiResource('/tImpuestos', 'TImpuestoController');

     Route::apiResource('/tipoImpuestos', 'TipoImpuestoController');
     Route::apiResource('/tipoPagosLegales', 'TipoPagosLegaleController');
     Route::apiResource('/tTipoHonorarios', 'TTipoHonorarioController');
     Route::apiResource('/tTipoIngresos', 'TTipoIngresoController');

     //Configuraciones Gestion del Contador
     Route::apiResource('/tPRemuneraciones', 'TPRemuneracioneController');
     Route::apiResource('/tPagoImpuestos', 'TTPagoImpuestoController');
     Route::apiResource('/tTareas', 'TTareaController');

     Route::apiResource('/tPrevisiones', 'TPrevisioneController');
     Route::apiResource('/tSaludes', 'TSaludeController');
     //Gestion del Contador
     Route::apiResource('/tPagoImpuestos', 'TPagoImpuestoController');
     Route::apiResource('/tGIngresos', 'TGIngresoController');
     Route::apiResource('/tGHonorarios', 'TGHonorarioController');
     Route::apiResource('/tGRemuneraciones', 'TGRemuneracioneController');

     Route::apiResource('/conDocTributarios', App\Http\Controllers\Contabilidad\ConDocTributarioController::class);

     //Cuarteles
     Route::apiResource('/parCuarteles', App\Http\Controllers\Parametros\ParCuartelController::class);


     //Remuneraciones

     //Registro asistencia
     Route::apiResource('/remLabores', 'RemLaboreController');
     Route::apiResource('/remAsistencias', 'remAsistenciaController');

     Route::apiResource('/facturaciones', 'FacturacioneController');
     Route::apiResource('/testadopagos', 'TEstadoPagoController');
     
 
     Route::get('/liquidacionDocts/liquidacion', 'LiquidacionDoctoController@show');
     Route::get('/compras/itemcompras', 'CompraController@compraProductos');
     
     Route::apiResource('/usersEmpresa', 'UserEmpresaController');
     Route::apiResource('/usersSucursal', 'UserSucursalController');
     
     Route::apiResource('/roles', 'RoleController');
    


     



     //Centros de Costos
     Route::apiResource('/parCCPadres', App\Http\Controllers\Parametros\ParCCPadreController::class);
     Route::apiResource('/parCCostos', App\Http\Controllers\Parametros\ParCCostoController::class);
     Route::apiResource('/parProyectos', App\Http\Controllers\Parametros\ParProyectoController::class);
     Route::apiResource('/parActFijos', App\Http\Controllers\Parametros\ParActFijoController::class);
     Route::apiResource('/parCCostosAcumulados', App\Http\Controllers\Parametros\ParCCostosAcumuladoController::class);

     //Boletas deHonorarios
     Route::apiResource('/conSiiHCompras', App\Http\Controllers\Contabilidad\ConSiiHCompraController::class);
     Route::apiResource('/conSiiHVentas', App\Http\Controllers\Contabilidad\ConSiiHVentaController::class);


     Route::apiResource('/parCMonetarias', App\Http\Controllers\Parametros\ParCMonetariaController::class);





     Route::apiResource('/venClientes', 'VenClienteController');
     Route::apiResource('/ccontables', 'CuentaController');
     Route::apiResource('/posProveedores', App\Http\Controllers\Pos\PosProveedorController::class);

     
     Route::get('/bodega/selectBodega', [App\Http\Controllers\Pos\PosBodegaController::class, 'selectBodega']);
     

     Route::apiResource('/items', 'ItemController');
     

     
     Route::get('/inventarios/kardex/{articulo}', 'InventarioController@kardex');
     Route::get('/inventarios/kardex2/{bodega}', 'InventarioController@kardex2');
     Route::get('/tesorerias/pagos/{cliente}', 'TesoreriaController@pagos');
     Route::apiResource('/inventarios', 'InventarioController');
     Route::apiResource('/compras', 'CompraController');
    
     Route::apiResource('/pedidodetalles', 'PedidoDetalleController');
     Route::apiResource('/pedidos', 'PedidoController');
     Route::apiResource('/traspasos', 'TraspasoController');

     Route::apiResource('/documentos', 'DocumentoController');
     Route::apiResource('/posMetodos', App\Http\Controllers\Pos\PosMetodoController::class);
     Route::apiResource('/impuestos', 'ImpuestoController');
     Route::apiResource('/centros', 'CentroController');
     Route::apiResource('/tesorerias', 'TesoreriaController');
     Route::apiResource('/familiacentros', 'FamiliaCentroController');
     Route::apiResource('/tesorerias', 'TesoreriaController');


});
Route::get('storage', function () {
     Artisan::call('storage:link');
});

//Indicadores
Route::get('/indicadores', function () {
     $data = Http::get('https://mindicador.cl/api')->json();

     return response()->json([
          'uf' => $data['uf']['valor'] ?? null,
          'utm' => $data['utm']['valor'] ?? null,
          'dolar' => $data['dolar']['valor'] ?? null,
     ]);
});



//Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//    return $request->user();
//});
