<?php

use App\Exports\ItemsExport;
use App\Exports\UsersExport;
use App\Exports\VentaExport;
use Illuminate\Http\Request;
use App\Exports\CompraExport;
use App\Exports\ItemscExport;
use App\Exports\CategoriasExport;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ExportController;
use App\Http\Controllers\Pos\PosCajaController;
use App\Http\Controllers\UserEmpresaController;
use App\Http\Controllers\UserSucursalController;
use App\Http\Controllers\Contabilidad\ConImpuestoTasaController;
use App\Http\Controllers\Contabilidad\ConLibroFoliadoController;
use App\Http\Controllers\PosImpuestoTasaController;
use App\Http\Controllers\Contabilidad\ConImpuestoCuentaController;

Route::group(['prefix' => 'api'], function () {

    //Login
    Route::post('/login', 'UserController@login');
    Route::post('/loginConfirmar', 'UserController@loginConfirmar');


      Route::apiResource('/parPeriodoEmpresas', App\Http\Controllers\Parametros\ParPeriodoEmpresaController::class);

    //Contabilidad
    Route::apiResource('/conAAutomaticos', App\Http\Controllers\Contabilidad\ConAAutomaticoController::class);

    

    //Articulos
    Route::apiResource('/parMedidas',  App\Http\Controllers\Parametros\ParMedidaController::class);
    Route::apiResource('/posArticulos', App\Http\Controllers\Pos\PosArticuloController::class);
   
    Route::get('/posArticulo/filtroESBodega', [App\Http\Controllers\Pos\PosArticuloController::class, 'filtroESBodega']);
    Route::get('/posArticulo/filtroEmpresa', [App\Http\Controllers\Pos\PosArticuloController::class, 'filtroEmpresa']);
    Route::apiResource('/posBodegaArticulos', App\Http\Controllers\Pos\PosBodegaArticuloController::class);
    Route::get('/posArticulo/filtroBAE', [App\Http\Controllers\Pos\PosArticuloController::class, 'filtroBAE']);
    Route::get('/posInventario/kardex', [App\Http\Controllers\Pos\PosInventarioController::class, 'Kardex']);

    //Impuestos
    Route::apiResource('/conImpuestos', App\Http\Controllers\Contabilidad\ConImpuestoController::class);
    Route::apiResource('/posArticuloImpuestos', App\Http\Controllers\Pos\PosArticuloImpuestoController::class);
    Route::apiResource('/posBodegaArticuloImpuestos', App\Http\Controllers\Pos\PosBodegaArticuloImpuestoController::class);
    
    Route::get('/posArticuloImpuesto/filtro', [App\Http\Controllers\Pos\PosArticuloImpuestoController::class, 'Filtro']);
    Route::get('/posBodegaArticuloImpuesto/filtro', [App\Http\Controllers\Pos\PosBodegaArticuloImpuestoController::class, 'Filtro']);

    Route::apiResource('/conImpuestoTasas', App\Http\Controllers\Contabilidad\ConImpuestoTasaController::class);
    Route::get('/conImpuestoTasa/tasa', [ConImpuestoTasaController::class, 'tasa']);

    //Traspasos
    Route::get('/posTraspaso/filtroDespacho', [App\Http\Controllers\Pos\PosTraspasoController::class, 'filtroDespacho']);
    Route::get('/posTraspaso/filtroRecepcion', [App\Http\Controllers\Pos\PosTraspasoController::class, 'filtroRecepcion']);


    

    Route::apiResource('/posCompras', App\Http\Controllers\Pos\PosCompraController::class);

    //Pos Venta

    Route::get('/posCajas/activa/{user_id}', [PosCajaController::class, 'cajaActiva']);
    Route::apiResource('/posCajas', App\Http\Controllers\Pos\PosCajaController::class);
    Route::apiResource('/posVentas', App\Http\Controllers\Pos\PosVentaController::class);

    //Pos Traspaso
    Route::apiResource('/posTraspasos', App\Http\Controllers\Pos\PosTraspasoController::class);
    Route::get('/posTraspaso/filtro', [App\Http\Controllers\Pos\PosTraspasoController::class, 'Filtro']);

    Route::apiResource('/tPermRoles', 'TPermRoleController');


    //Pos-Parametros

    Route::apiResource('/posMaquinarias', App\Http\Controllers\Pos\PosMaquinariaController::class);

     

    Route::apiResource('/conRendiciones', App\Http\Controllers\Contabilidad\ConRendicionController::class);
     Route::apiResource('/remCargos', 'RemCargoController');

    Route::apiResource('/posBodegas', App\Http\Controllers\Pos\PosBodegaController::class);

        Route::apiResource('/posClientes', App\Http\Controllers\Pos\PosClienteController::class);

             Route::apiResource('/sucursals', 'SucursalController');
             Route::apiResource('/users', 'UserController');
              Route::post('usersEmpresa/lote', [UserEmpresaController::class, 'store']);
     Route::post('usersSucursal/lote', [UserSucursalController::class, 'store']);


    Route::get('/conRendicione/filtro', [App\Http\Controllers\Contabilidad\ConRendicionController::class, 'Filtro']);

    Route::get('/mantencionDetalle/filtroMaquinaria', 'MantencionDetalleController@FiltroMaquinaria');
   Route::get('/Dpanguimaq/filtroMesEnCurso', 'DPanguimaqController@MesEnCurso');
   Route::get('/Dpanguimaq/filtroMesEnCursoMantencion', 'DPanguimaqController@MesEnCursoMantencion');
   Route::get('/Dpanguimaq/filtroMesEnCursoMantencionPropias', 'DPanguimaqController@MesEnCursoManPropias');

   Route::get('/DMantencione/filtroManteniones', 'DMantencionesController@maquinariasActivas');
   Route::get('/DMantencione/filtroAvanzado', 'DMantencionesController@filtroAvanzado');
   Route::get('/DMantencione/filtroAvanzadoArriendos', 'DMantencionesController@fAvanzadoArriendos');
   Route::get('/DMantencione/filtroAvanzadoMaquinarias', 'DMantencionesController@fAvanzadoMaquinarias');
   Route::get('/DMantencione/fAvanzadoManteciones', 'DMantencionesController@fAvanzadoManteciones');
   Route::get('/DMantencione/fAvanzadoMDetalles', 'DMantencionesController@fAvanzadoMDetalles');

   Route::get('/Maquinaria/filtroAvanzado', [App\Http\Controllers\Pos\PosMaquinariaController::class, 'filtroAvanzado']);

    Route::apiResource('/parMarcas', App\Http\Controllers\Parametros\ParMarcaController::class);
    Route::apiResource('/parCategorias', App\Http\Controllers\Parametros\ParCategoriaController::class);
    Route::apiResource('/parTMaquinarias', App\Http\Controllers\Parametros\ParTMaquinariaController::class);

    Route::post('/conLibroFoliados/foliarAnualMayor', [ConLibroFoliadoController::class, 'foliarAnualMayor']);
    Route::get('/conLibroFoliado/filtro', [App\Http\Controllers\Contabilidad\ConFolioLibroController::class, 'filtro']);
    Route::apiResource('/remAfps', 'RemAfpController');
    Route::apiResource('/remSaluds', 'RemSaludController');

    Route::get('/remHistorialAfpSalud/filtro', 'RemHistorialAfpSaludController@filtro');
    Route::apiResource('/remDocContratos', 'RemDocContratoController');
    Route::apiResource('/remTipoContratos', 'RemTipoContratoController');
    Route::get('/remContrato/filtro', 'RemContratoController@Filtro');
    Route::apiResource('/remContratos', 'RemContratoController');
    Route::apiResource('/remTipoRemuneraciones', 'RemTipoRemuneracionController');

});






Route::get('storage', function () {
    Artisan::call('storage:link');
});




Route::get('/', function () {
    return view('welcome');
});
