<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Libro Diario</title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 9px;
            margin: 10px;
        }

        .titulo-principal {
            text-align: center;
            font-size: 14px;
            margin-bottom: 10px;
            page-break-after: avoid;
        }

        .header-info {
            font-size: 9px;
            margin-bottom: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
            page-break-inside: avoid;
        }

        thead {
            display: table-header-group;
        }

        thead th {
            border-bottom: 1px solid black;
            text-align: left;
            font-weight: bold;
            padding: 4px;
        }

        tbody td {
            border: none;
            border-bottom: 1px solid #ccc;
            padding: 4px;
            vertical-align: top;
        }

        .text-right { text-align: right; }
        .text-center { text-align: center; }
    </style>
</head>
<body>
<div class="titulo-principal">
    <?php echo e($tituloLibro); ?>

</div>

<?php $__currentLoopData = $datos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $asiento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php
        $totalDebe = 0;
        $totalHaber = 0;
        $lineas = collect($asiento['libro_diarios'] ?? [])->sortBy([
            fn($a) => $a['haber'] > 0 ? 1 : 0,
            fn($a) => $a['sub_cuenta']['codigo'] ?? '',
        ]);
    ?>

   <table border="0" cellspacing="0" cellpadding="4" style="width:100%; font-size:8px;">
    <thead>
        <tr>
            <th width="9%" style="border-bottom: 2px solid #000;"><b>Fecha</b></th>
            <th width="12%" style="border-bottom: 2px solid #000;"><b>Comprobante</b></th>
            <th width="8%" style="border-bottom: 2px solid #000;"><b>Tipo</b></th>
            <th width="11%" style="border-bottom: 2px solid #000;"><b>Código</b></th>
            <th width="17%" style="border-bottom: 2px solid #000;"><b>Nombre</b></th>
            <th width="23%" style="border-bottom: 2px solid #000;"><b>Glosa</b></th>
            <th width="10%" style="border-bottom: 2px solid #000;" align="right"><b>Debe</b></th>
            <th width="10%" style="border-bottom: 2px solid #000;" align="right"><b>Haber</b></th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $lineas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td valign="top" width="9%" style="border-bottom: 0.2px solid #ccc;"><?php echo e($asiento['fecha'] ?? ''); ?></td>
            <td valign="top" width="12%" style="border-bottom: 0.2px solid #ccc;"><?php echo e($asiento['folio'] ?? ''); ?></td>
            <td valign="top" width="8%" style="border-bottom: 0.2px solid #ccc;"><?php echo e($asiento['con_t_vouchers']['nombre'] ?? ''); ?></td>
            <td valign="top" width="11%" style="border-bottom: 0.2px solid #ccc;"><?php echo e($d['sub_cuenta']['codigo'] ?? ''); ?></td>
            <td valign="top" width="17%"style="border-bottom: 0.2px solid #ccc;"><?php echo e($d['sub_cuenta']['nombre'] ?? ''); ?></td>
            <td valign="top" width="23%" style="border-bottom: 0.2px solid #ccc;"><?php echo e($asiento['glosa'] ?? ''); ?></td>
            <td valign="top" align="right" width="10%" style="border-bottom: 0.2px solid #ccc;"><?php echo e(number_format($d['debe'] ?? 0, 0, ',', '.')); ?></td>
            <td valign="top" align="right" width="10%" style="border-bottom: 0.2px solid #ccc;"><?php echo e(number_format($d['haber'] ?? 0, 0, ',', '.')); ?></td>
        </tr>
        <?php
            $totalDebe += floatval($d['debe'] ?? 0);
            $totalHaber += floatval($d['haber'] ?? 0);
        ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <tr>
            <td colspan="6" align="right" style="border-top: 1px solid #000;"><b>TOTALES</b></td>
            <td align="right" style="border-top: 1px solid #000;"><b><?php echo e(number_format($totalDebe, 0, ',', '.')); ?></b></td>
            <td align="right" style="border-top: 1px solid #000;"><b><?php echo e(number_format($totalHaber, 0, ',', '.')); ?></b></td>
        </tr>
    </tbody>
</table>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


</body>
</html>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/api/resources/views/pdfs/libro_diario_tcpdf.blade.php ENDPATH**/ ?>