<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <style>
        @page {
            size: 80mm auto;
            margin: 0;
        }

        * {
            font-family: monospace;
            font-size: 12px;
            box-sizing: border-box;
        }

        body {
            margin: 0;
            padding: 10px;
        }

        h1, h2 {
            text-align: center;
            margin: 0;
            padding: 2px 0;
        }

        .info-cliente, .retira {
            margin-top: 5px;
            font-weight: bold;
            word-wrap: break-word;
            white-space: normal;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th, td {
            padding: 4px;
            border-bottom: 1px dashed #000;
            vertical-align: top;
        }

        td.producto {
            word-break: break-word;
            max-width: 120px;
        }

        .firma {
            text-align: center;
            margin-top: 20px;
            font-size: 12px;
        }

        .thanks {
            text-align: center;
            margin-top: 10px;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <h1>PANQUIMAQ</h1>
    <h2>MANTENCIÓN N° <?php echo e($mantencione->id); ?></h2>
    <h2><?php echo e($mantencione->fecha); ?></h2>

    <p class="info-cliente">Cliente: <?php echo e($mantencione->venCliente->nombre); ?></p>

    <table>
        <thead>
            <tr>
                <th>MAQUINARIA</th>
                <th>DETALLE</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $mantencione->mantencione_detalles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="producto"><?php echo e($d->maquinaria->nombre); ?></td>
                    <td class="producto"><?php echo e($d->detalle); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <p class="retira">Recibe: <?php echo e($mantencione->recepciona); ?></p>

    <div class="firma">
        __________________________<br>
        Firma
    </div>

    <p class="thanks">¡GRACIAS POR SU VISITA!</p>
</body>
</html>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/api/resources/views/reports/mingreso.blade.php ENDPATH**/ ?>