<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <style>
        @page {
            size: 80mm auto;
            margin: 0;
        }

        * {
            font-family: monospace;
            font-size: 11px;
            box-sizing: border-box;
        }

        body {
            margin: 0;
            padding: 10px;
        }

        h1, h2, p {
            text-align: center;
            margin: 2px 0;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th, td {
            padding: 4px;
            border-bottom: 1px dashed #000;
        }

        td.precio {
            text-align: right;
        }

        td.cantidad, td.producto, td.detalle {
            word-wrap: break-word;
            white-space: normal;
        }

        .total {
            font-weight: bold;
            border-top: 1px solid #000;
        }

        .firma {
            text-align: center;
            margin-top: 20px;
            font-size: 11px;
        }

        .thanks {
            text-align: center;
            margin-top: 10px;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <h1>PANQUIMAQ</h1>
    <h2>DESPACHO N° <?php echo e($mDespacho->id); ?></h2>
    <h2><?php echo e($mDespacho->fecha); ?></h2>

    <p>Cliente: <?php echo e($mDespacho->venCliente->nombre); ?></p>

    <table>
        <thead>
            <tr>
                <th>CANT</th>
                <th>MAQ</th>
                <th>DETALLE</th>
                <th>$/U</th>
                <th>$$</th>
            </tr>
        </thead>
        <tbody>
            <?php $total_general = 0; ?>
            <?php $__currentLoopData = $mDespacho->mantencione_detalles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detalle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $__currentLoopData = $detalle->m_d_mantenciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $subtotal = $d->valor * $d->cantidad; ?>
                    <tr>
                        <td><?php echo e(number_format($d->cantidad, 0, ',', '.')); ?></td>
                        <td class="producto"><?php echo e($d->maquinaria->nombre); ?></td>
                        <td class="detalle"><?php echo e($d->detalle); ?></td>
                        <td class="precio"><?php echo e(number_format($d->valor, 0, ',', '.')); ?></td>
                        <td class="precio"><?php echo e(number_format($subtotal, 0, ',', '.')); ?></td>
                    </tr>
                    <?php $total_general += $subtotal; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <tr class="total">
                <td colspan="4">TOTAL</td>
                <td class="precio"><?php echo e(number_format($total_general, 0, ',', '.')); ?></td>
            </tr>
        </tbody>
    </table>

    <p>Retira: <?php echo e($mDespacho->retira); ?></p>

    <div class="firma">
        __________________________<br>
        Firma
    </div>

    <p class="thanks">¡GRACIAS POR SU ARRIENDO!</p>
</body>
</html>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/api/resources/views/reports/mdespacho.blade.php ENDPATH**/ ?>