<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <style>
        @page {
            size: 80mm auto;
            margin: 0;
        }

        * {
            font-family: monospace;
            font-size: 12px;
        }

        body {
            margin: 0;
            padding: 10px;
        }

        h1, h2 {
            text-align: center;
            margin: 0;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th, td {
            padding: 4px;
            border-bottom: 1px dashed #000;
        }

        td.precio {
            text-align: right;
        }

        .total {
            font-weight: bold;
            border-top: 1px solid #000;
        }

        .firma {
            text-align: center;
            margin-top: 20px;
            font-size: 12px;
        }

        .thanks {
            text-align: center;
            margin-top: 10px;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <h1>PANQUIMAQ</h1>
    <h2>ARRIENDO N° <?php echo e($arriendo->id); ?></h2>
    <h2><?php echo e($arriendo->fecha); ?></h2>

    <p>Cliente: <?php echo e($arriendo->venCliente->nombre); ?></p>

    <table>
        <thead>
            <tr>
                <th>CANT</th>
                <th>PRODUCTO</th>
                <th>$$</th>
            </tr>
        </thead>
        <tbody>
            <?php $total = 0; ?>
            <?php $__currentLoopData = $arriendo->arriendo_detalles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $total += $d->maquinaria->garantia; ?>
                <tr>
                    <td><?php echo e($d->cantidad); ?></td>
                    <td><?php echo e($d->maquinaria->nombre); ?></td>
                    <td class="precio"><?php echo e(number_format($d->maquinaria->garantia, 0, ',', '.')); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <tr class="total">
                <td colspan="2">TOTAL</td>
                <td class="precio"><?php echo e(number_format($total, 0, ',', '.')); ?></td>
            </tr>
        </tbody>
    </table>

    <p>Retira: <?php echo e($arriendo->retira); ?></p>

    <div class="firma">
        __________________________<br>
        Firma
    </div>

    <p class="thanks">¡GRACIAS POR SU ARRIENDO!</p>
</body>
</html><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/api/resources/views/reports/arriendoe.blade.php ENDPATH**/ ?>